<?php

namespace Import\ApiBundle\Services\Import;


class ImportSessionCurrency extends ImportMainService
{
    protected $urlZip = 'http://bossa.pl/pub/waluty/mstock/sesjanbp/few_last.zip';

    protected $columns = array("Name","Date","Open","High","Low","Close","Volume");

    protected $type = 'Currency';

    public function import()
    {
        $data = $this->getCSVFromZip($this->urlZip,$this->type,$this->columns);

        $i = 0;
        foreach($data as $row)
        {
            $this->save($row);
            $i++;
        }

        $this->getDoctrine()->getEntityManager()->flush();
        $this->viewErrors();

        return array('count' => $i);
    }

    protected function save($data)
    {
        $data['Currency'] = $this->getCurrencyBySymbol($data['Name']);
        $SessionIndexGPW = $this->getDoctrine()->getRepository('ImportApiBundle:SessionCurrency')->add($data);

        return $SessionIndexGPW;
    }
}